﻿

CREATE PROCEDURE [App].[NVCC_usp_GetLogs]

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetLogs
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-09-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To retrieve the relevant production logs for creating PDF's.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

	SELECT
		al.*,
		p.Sta3n,
		s.StaffName,
		CONVERT(Date, AccessDateTime) AS Date,
		convert(varchar, convert(date, dateadd(day, 7 * (datediff(day, '1990-01-07', al.AccessDateTime) / 7), '1990-01-07'))) + ' - ' + convert(varchar, convert(date, dateadd(day, (7 * (datediff(day, '1990-01-07', al.AccessDateTime) / 7)) + 6, '1990-01-07'))) AS Week,
		format(datepart(year, al.AccessDateTime), '0000') + '-' + format(datepart(month, al.AccessDateTime), '00') AS YearMon
	FROM
		App.vNVCC_ProductionAccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
		LEFT JOIN App.NVCC_Users u
			ON al.UserID = u.DomainPlusNetworkUserName
		LEFT JOIN CDWWork.SStaff.SStaff s
			ON u.UserIEN = s.StaffIEN and u.Sta3n = s.Sta3n
	ORDER BY
		al.AccessDateTime
END;


